<?php

namespace MbeGroup\Job\Filament\Resources;

use MbeGroup\Job\Models\Application;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Actions;
use MbeGroup\Job\Filament\Resources\ApplicationResource\Pages;
use App\Helpers\DictionaryHelper;

class ApplicationResource extends Resource
{
    protected static ?string $model = Application::class;

    public static function getNavigationGroup(): string
    {
        return __('job::filament.navigation.group.label');
    }

    public static function getNavigationLabel(): string
    {
        return __('job::filament.resources.application.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('job::filament.resources.application.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('job::filament.resources.application.plural_model_label');
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('ID')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('jobOffer.title')
                    ->label(__('job::filament.resources.application.table.columns.title'))
                    ->searchable()
                    ->limit(50)
                    ->toggleable(),
                Tables\Columns\TextColumn::make('employer.name')
                    ->label(__('job::filament.resources.application.table.columns.employer'))
                    ->placeholder('Brak danych')
                    ->searchable()
                    ->toggleable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('type.name')
                    ->label(__('job::filament.resources.application.table.columns.type'))
                    ->placeholder('Brak danych')
                    ->searchable()
                    ->toggleable(),
                Tables\Columns\TextColumn::make('candidate_first_name')
                    ->label(__('job::filament.resources.application.table.columns.user.name'))
                     ->placeholder('Brak danych')
                    ->searchable()
                    ->toggleable(),
                Tables\Columns\TextColumn::make('candidate_last_name')
                    ->label(__('job::filament.resources.application.table.columns.user.surname'))
                    ->placeholder('Brak danych')
                    ->searchable()
                    ->toggleable(),
                Tables\Columns\TextColumn::make('candidate_email')
                    ->label(__('job::filament.resources.application.table.columns.user.email'))
                    ->placeholder('Brak danych')
                    ->searchable()
                    ->toggleable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('job::filament.resources.application.table.columns.created_at'))
                    ->dateTime()
                    ->toggleable()
                    ->sortable(),
            ])
            ->defaultSort('created_at', 'desc')
            ->filters([
                Tables\Filters\SelectFilter::make('type_id')
                    ->label('Typ aplikacji')
                    ->options(DictionaryHelper::getNamesByType('application_method'))
                    ->query(function ($query, array $data) {
                        if (filled($data['value'])) {
                            return $query->where('type_id', (int) $data['value']);
                        }
                        return $query;
                    })
                    ->searchable(),
            ])
            ->recordActions([
                Actions\ViewAction::make()
                    ->iconButton()
                    ->color('gray'),
            ])
            ->toolbarActions([
                Actions\BulkActionGroup::make([
                ]),
            ])
            ->description('Version: ' . \Composer\InstalledVersions::getVersion('mbegroup/job'));
    }

    public static function getRelations(): array
    {
        return [
                    //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListApplications::route('/'),
            'view'  => Pages\ViewApplication::route('/{record}'),
        ];
    }
}
