<?php

namespace MbeGroup\Job\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class JobOfferResource extends JsonResource
{
      /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $resource = [
            'id'       => $this->public_id,
            'employer' => $this->employer ? [
                'id'       => $this->employer->id,
                'name'     => $this->employer->name,
                'slug'     => $this->employer->slug,
                'logo_url' => $this->employer->getLogoUrlAttribute(),
                'banner_image' => $this->employer->getBannerImageUrlAttribute(),
                'company_type' => $this->employer->companyType ? [
                    'id'   => $this->employer->companyType->id,
                    'name' => $this->employer->companyType->name,
                    'slug' => $this->employer->companyType->slug,
                ] : null,
                'company_size' => $this->employer->companySize ? [
                    'id'   => $this->employer->companySize->id,
                    'name' => $this->employer->companySize->name,
                    'slug' => $this->employer->companySize->slug,
                ] : null,
                'industry' => $this->employer->industry ? [
                    'id'   => $this->employer->industry->id,
                    'name' => $this->employer->industry->name,
                    'slug' => $this->employer->industry->slug,
                ] : null,
                'default_location' => $this->employer->default_location,
                'offers_count' => $this->employer->job_offers_count,
            ] : null,
            'title'                                    => $this->title,
            'slug'                                     => $this->slug,
            'reference_number'                         => $this->reference_number,
            'status'                                   => $this->status,
            'locations'                                => $this->locations,
            'industries'                               => $this->getIndustries(),
            'specializations'                          => $this->getSpecializations(),
            'position'                                 => $this->getPosition(),
            'position_level'                           => $this->getPositionLevel(),
            'is_for_technicians'                       => $this->is_for_technicians,
            'operating_modes'                          => $this->getOperatingModes(),
            'is_remote_recruitment'                    => $this->is_remote_recruitment,
            'employment_types'                         => $this->getEmploymentTypes(),
            'hourly_rate'                              => $this->getHourlyRate(),
            'preferred_studies'                        => $this->getPreferredStudies(),
            'workplace_types'                          => $this->getWorkplaceTypes(),
            'work_system'                              => $this->getWorkSystem(),
            'delegations'                              => $this->getDelegations(),
            'contract_duration'                        => $this->getContractDuration(),
            'salary_structures'                        => $this->getSalaryStructures(),
            'has_team_management'                      => $this->has_team_management,
            'has_driving_license'                      => $this->has_driving_license,
            'no_experience'                            => $this->no_experience,
            'has_company_car'                          => $this->has_company_car,
            'competences'                              => $this->getPreparedCompetences(),
            'application_method'                       => $this->application_method,
            'is_top_offer'                             => $this->is_top_offer,
            'salary'                                   => $this->getPreparedSalary(),
            'template_benefits'                        => !empty($this->template_benefits)
                ? array_map(function ($benefit) {
                    return [
                        'benefit_icon'        => !empty($benefit['benefit_icon'])
                            ? url('storage/' . ltrim($benefit['benefit_icon'], '/'))
                            : null,
                        'benefit_description' => $benefit['benefit_description'] ?? null,
                    ];
                }, $this->template_benefits)
                : [],
            'template_recruitment_stages'              => $this->template_recruitment_stages,
            'publication_date'                         => $this->publication_date,
            'expiration_date'                          => $this->expiration_date,
            'template'                                 => $this->template,
            'created_at'                               => $this->created_at,
            'updated_at'                               => $this->updated_at,
        ];
        return $resource;
    }
}
