<?php

namespace MbeGroup\Job\Models;

use App\ValueObject\Status;

class ArchivedJobOffer extends JobOffer
{
    protected $collection = 'archived_job_offers';

    protected $casts = [
        'status'           => Status::class,
        'locations'        => 'array',
        'publication_date' => 'datetime',
        'expiration_date'  => 'datetime',
        'archived_at'      => 'datetime',
    ];

    public function shouldBeSearchable()
    {
        return false;
    }

    public function getFillable()
    {
        return array_merge(parent::getFillable(), [
            'archived_at',
            'archived_reason',
            'original_collection',
        ]);
    }
}
