<?php

namespace MbeGroup\Job\Controllers\Api\V1;

use App\Http\Controllers\Api\V1\CrudApiController;
use App\ValueObject\Status;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use MbeGroup\Job\Resources\JobOfferResource;
use MbeGroup\Job\Contracts\JobOffersSearchServiceInterface;
use MbeGroup\Job\Models\JobOffer;

final class JobOfferController extends CrudApiController
{
    protected string $resourceName = 'job-offer';

    public function __construct(
        protected JobOffersSearchServiceInterface $searchService,
    ) {
    }

    public function search(Request $request): JsonResponse
    {
        $filters = $request->only([
            'q',
            'industry_ids',
            'specialization_ids',
            'employer_ids',
            'lat',
            'lon',
            'distance',
            'position_ids',
            'position_level_ids',
            'operating_mode_ids',
            'salary_employment_type_ids',
            'hourly_rate_ids',
            'only_with_salary',
            'min_salary',
            'preferred_study_ids',
            'workplace_type_ids',
            'work_system_id',
            'delegations_id',
            'contract_duration_id',
            'salary_structure_ids',
            'has_team_management',
            'has_driving_license',
            'no_experience',
            'has_company_car',
            'is_remote_recruitment',
            'is_for_technicians',
            'company_size_ids',
            'company_type_ids',
            'sort_by',
        ]);
        $perPage  = (int) $request->input('limit', self::PER_PAGE_DEFAULT);
        $page     = (int) $request->input('page', 1);
        $jobOffers = $this->searchService->search($filters, $perPage, $page);

        $this->initSeo(null, $this->resourceName . '::seo.all');

        return $this->success(JobOfferResource::collection($jobOffers),[
            'pagination' => [
                'total'        => $jobOffers->total(),
                'per_page'     => $jobOffers->perPage(),
                'current_page' => $jobOffers->currentPage(),
                'last_page'    => $jobOffers->lastPage(),
            ]
        ]);
    }

    public function index(Request $request): JsonResponse
    {
        return $this->notImplemented('index');
    }

    public function show(string $id): JsonResponse
    {
        $jobOffer = JobOffer::where('public_id', $id)->first();

        if (!$jobOffer) {
            return $this->error('Nie znaleziono oferty pracy.', null, 404);
        }

        return $this->success(new JobOfferResource($jobOffer));
    }

    public function store(Request $request): JsonResponse
    {
        return $this->notImplemented('store');
    }

    public function update(Request $request, string $id): JsonResponse
    {
        return $this->notImplemented('update');
    }

    public function destroy(string $id): JsonResponse
    {
        return $this->notImplemented('destroy');
    }
}
