<?php

namespace MbeGroup\Job\Contracts;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface ApplicationServiceInterface
{
    /**
     * Pobiera listę aplikacji dla danego użytkownika
     *
     * @param mixed $user Obiekt użytkownika, dla którego mają być pobrane aplikacje
     * @return LengthAwarePaginator Zwraca paginowaną listę aplikacji
     */
    public function getApplicationsForUser($user, int $page = 1, int $perPage = 15): LengthAwarePaginator;
}
