<?php

namespace MbeGroup\Job\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;
use MbeGroup\Notification\Models\Notification;

class JobAlertMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        private Notification $notification,
        private Collection $jobs
    ) {}

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Nowe oferty pracy: ' . $this->notification->name,
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'job::emails.alert',
            with: [
                'jobs'         => $this->jobs,
                'notification' => $this->notification,
            ],
        );
    }
}
