<?php

namespace MbeGroup\Job\Providers\NotificationProviders;

use MbeGroup\Notification\Contracts\NotificationProviderInterface;
use MbeGroup\Notification\Models\Notification;
use Illuminate\Support\Collection;
use Illuminate\Mail\Mailable;
use Carbon\Carbon;
use MbeGroup\Job\Models\JobOffer;
use MbeGroup\Job\Mail\JobAlertMail;
use MbeGroup\Job\Contracts\JobOffersSearchServiceInterface;
use MbeGroup\Job\Resources\JobOfferSearchResource;

final class JobNotificationProvider implements NotificationProviderInterface
{
    public function getItems(array $query, ?Carbon $publishedAfter, int $limit = 3): Collection
    {
        $service = app(JobOffersSearchServiceInterface::class);
        $jobOffers = $service->search($query, $limit, 1);

        return collect(JobOfferSearchResource::collection($jobOffers)->resolve());
    }

    public function getMailable(Notification $notification, Collection $items): Mailable
    {
        return new JobAlertMail($notification, $items);
    }
}
