<?php

namespace MbeGroup\Job\Contracts;

use Illuminate\Support\Collection;

interface JobOfferRecommendationServiceInterface
{
    /**
     * Prepare data from request for recommendation.
     *
     * @param array $requestData
     * @return array
     */
    public function prepareDataFromRequest(array $requestData): array;

    /**
     * Add filter data to user recommendation.
     *
     * @param array $data
     * @param string $type
     * @return array
     */
    public function addFilterDataToUserRecommendation(array $data, string $type): array;

    /**
     * Get recommendations by filter.
     *
     * @param array $data
     * @return array
     */
    public function findUserJobRecomendation(int $userId): array;

    /**
     * Get user recommendation by type.
     *
     * @param int $userId
     * @param string $type
     * @param array $excludedFilters
     * @return array
     */
    public function findUserJobRecomendationByType(int $userId, string $type, array $excludedFilters = []): array;
}
