<?php

namespace MbeGroup\Job\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class JobOfferSearchResource extends JsonResource
{
    /**
     * Transform the search index array into an API response array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data     = is_array($this->resource) ? $this->resource : $this->resource->toArray();
        $employer = $data['employer'] ?? null;

        return [
            'id'       => $data['public_id'] ?? null,
            'employer' => $employer ? [
                'id'               => $employer['id'] ?? null,
                'name'             => $employer['name'] ?? null,
                'slug'             => $employer['slug'] ?? null,
                'logo_url'         => $employer['logo_url'] ?? null,
                'banner_image'     => $employer['banner_image'] ?? null,
                'company_type'     => $employer['company_type'] ?? null,
                'company_size'     => $employer['company_size'] ?? null,
                'industry'         => $employer['industry'] ?? null,
                'default_location' => $employer['default_location'] ?? null,
                'offers_count'     => $employer['offers_count'] ?? null,
            ] : null,
            'title'                       => $data['title'] ?? null,
            'slug'                        => $data['slug'] ?? null,
            'reference_number'            => $data['reference_number'] ?? null,
            'status'                      => $data['status'] ?? null,
            'locations'                   => $data['locations'] ?? [],
            'industries'                  => $data['industries'] ?? null,
            'specializations'             => $data['specializations'] ?? null,
            'position'                    => $data['position'] ?? null,
            'position_level'              => $data['position_level'] ?? null,
            'is_for_technicians'          => $data['is_for_technicians'] ?? null,
            'operating_modes'             => $data['operating_modes'] ?? null,
            'is_remote_recruitment'       => $data['is_remote_recruitment'] ?? null,
            'hourly_rate'                 => $data['hourly_rate'] ?? null,
            'preferred_studies'           => $data['preferred_studies'] ?? null,
            'workplace_types'             => $data['workplace_types'] ?? null,
            'work_system'                 => $data['work_system'] ?? null,
            'delegations'                 => $data['delegations'] ?? null,
            'contract_duration'           => $data['contract_duration'] ?? null,
            'salary_structures'           => $data['salary_structures'] ?? null,
            'has_team_management'         => $data['has_team_management'] ?? null,
            'has_driving_license'         => $data['has_driving_license'] ?? null,
            'no_experience'               => $data['no_experience'] ?? null,
            'has_company_car'             => $data['has_company_car'] ?? null,
            'is_for_delegations'          => $data['is_for_delegations'] ?? null,
            'competences'                 => $data['competences'] ?? [],
            'application_method'          => $data['application_method'] ?? null,
            'is_top_offer'                => $data['is_top_offer'] ?? null,
            'salary'                      => $data['salary'] ?? [],
            'template_benefits'           => $data['template_benefits'] ?? [],
            'template_recruitment_stages' => $data['template_recruitment_stages'] ?? null,
            'template_about_project'      => $data['template_about_project'] ?? null,
            'template_css'                => $data['template_css'] ?? null,
            'publication_date'            => $data['publication_date'] ?? null,
            'expiration_date'             => $data['expiration_date'] ?? null,
            'template'                    => $data['template'] ?? null,
            'created_at'                  => $data['created_at'] ?? null,
            'updated_at'                  => $data['updated_at'] ?? null,
        ];
    }
}
