<?php

namespace MbeGroup\Job\Services;

use MbeGroup\Job\Contracts\ApplicationServiceInterface;
use MbeGroup\Job\Models\Application;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

class ApplicationService implements ApplicationServiceInterface
{
    public function getApplicationsForUser($user, int $page = 1, int $perPage = 15): LengthAwarePaginator
    {
        return Application::where('user_id', $user->id)
            ->orderBy('created_at', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);
    }
}
