<?php

namespace MbeGroup\Notification\Models;

use MongoDB\Laravel\Eloquent\Model;
use App\ValueObject\Status;

class Notification extends Model
{
    protected $connection = 'mongodb';
    protected $collection = 'notifications';

    protected $fillable = [
        'query',
        'type',
        'frequency',
        'last_sent_at',
        'last_queried_at',
        'user_id',
        'status',
        'name',
    ];

    protected $casts = [
        'created_at'      => 'datetime',
        'updated_at'      => 'datetime',
        'last_sent_at'    => 'datetime',
        'last_queried_at' => 'datetime',
        'status'          => Status::class,
    ];
}
