<?php
namespace MbeGroup\Notification\Providers;

use Illuminate\Support\ServiceProvider;
use MbeGroup\Notification\Models\Notification;

final class NotificationServiceProvider extends ServiceProvider
{
    public function register(): void
    {

    }

    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__ . '/../../routes/api.php');
        $this->loadRoutesFrom(__DIR__ . '/../../routes/console.php');
        $this->loadTranslationsFrom(__DIR__ . '/../../lang', 'notification');
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'notification');
        if ($this->app->runningInConsole()) {
            $this->commands([
            ]);
        }
    }
}
