<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; background: #f4f4f4; margin: 0; padding: 20px; }
        .container { max-width: 600px; margin: 0 auto; background: #fff; padding: 20px; border-radius: 8px; }
        .section { margin-bottom: 32px; border-bottom: 2px solid #e0e0e0; padding-bottom: 24px; }
        .section:last-child { border-bottom: none; }
        .section-title { font-size: 20px; font-weight: bold; margin-bottom: 16px; color: #1a1a1a; }
        .offer { border: 1px solid #e0e0e0; border-radius: 6px; padding: 16px; margin-bottom: 12px; }
        .offer h2 { margin: 0 0 8px; font-size: 16px; }
        .offer .employer { color: #666; font-size: 14px; margin-bottom: 12px; }
        .btn { display: inline-block; background: #2563eb; color: #fff; padding: 10px 20px; border-radius: 4px; text-decoration: none; font-size: 14px; }
        .footer { margin-top: 20px; font-size: 12px; color: #999; }
    </style>
</head>
<body>
    <div class="container">
        @foreach($results as $result)
        <div class="section">
            <div class="section-title">{{ $result['notification']->name }}</div>

            @foreach($result['items'] as $job)
            <div class="offer">
                <h2>{{ $job['title'] }}</h2>
                <div class="employer">{{ $job['employer']['name'] ?? '' }}</div>
                <a href="{{ url('/praca/' . $job['slug']) }}" class="btn">Zobacz ofertę</a>
            </div>
            @endforeach
        </div>
        @endforeach

        <div class="footer">
            Otrzymujesz ten email ponieważ ustawiłeś powiadomienia o nowych ofertach pracy.
        </div>
    </div>
</body>
</html>
