<?php

namespace MbeGroup\Notification\Contracts;

use Illuminate\Support\Collection;
use Illuminate\Mail\Mailable;
use MbeGroup\Notification\Models\Notification;
use Carbon\Carbon;

interface NotificationProviderInterface
{
    /**
     * Retrieves items based on the provided query and publication date.
     *
     * @param array $query The query parameters for filtering items.
     * @param Carbon|null $publishedAfter Optional date to filter items published after this date.
     * @param int $limit The maximum number of items to retrieve (default is 3).
     * @return Collection A collection of items matching the query and publication date criteria.
     */
    public function getItems(array $query, ?Carbon $publishedAfter, int $limit = 3): Collection;

    /**
     * Generates a mailable object for the given notification and items.
     *
     * @param Notification $notification The notification for which the mailable is being generated.
     * @param Collection $items The collection of items to be included in the mailable.
     * @return Mailable A mailable object that can be sent to users.
     */
    public function getMailable(Notification $notification, Collection $items): Mailable;
}
