<?php

namespace MbeGroup\Notification\Contracts;

use MbeGroup\Notification\Models\Notification;
use MbeGroup\Notification\Exceptions\UnsupportedNotificationTypeException;

interface NotificationServiceInterface
{
    /**
     * Stores a new notification based on the provided data, type, and user ID.
     *
     * @param array $data The data for the notification, including name, frequency, and query.
     * @param string $type The type of the notification, which determines the provider to use.
     * @param int $userId The ID of the user for whom the notification is being created.
     * @return Notification The created notification instance.
     *
     * @throws UnsupportedNotificationTypeException If the provided notification type is not supported by any provider.
     */
    public function store(array $data, string $type, int $userId): Notification;
}
