<?php

namespace MbeGroup\Notification\Controllers\Api\V1;

use App\Http\Controllers\Api\V1\CrudApiController;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use MbeGroup\Notification\Contracts\NotificationServiceInterface;
use MbeGroup\Notification\Requests\StoreNotificationRequest;
use MbeGroup\Notification\Resources\NotificationResource;
use MbeGroup\Notification\Exceptions\UnsupportedNotificationTypeException;

final class NotificationController extends CrudApiController
{
    protected string $resourceName = 'notification';

    public function __construct(
        private NotificationServiceInterface $service
    ) {}

    public function index(Request $request): JsonResponse
    {
        return $this->notImplemented('index');
    }

    public function show(string $id): JsonResponse
    {
        return $this->notImplemented('show');
    }

    public function store(Request $request): JsonResponse
    {
        $formRequest = app(StoreNotificationRequest::class);
        $type        = $request->route('type');

        try {
            $notification = $this->service->store(
                data  : $formRequest->validated(),
                type  : $type,
                userId: auth()->id(),
            );
        } catch (UnsupportedNotificationTypeException $e) {
            return $this->error($e->getMessage(), 422);
        } catch (\InvalidArgumentException $e) {
            return $this->error($e->getMessage(), 422);
        } catch (\Exception $e) {
            return $this->error($e->getMessage(), 500);
        }

        return $this->success(
            new NotificationResource($notification),
            [],
            'Powiadomienie zostało utworzone pomyślnie'
        );
    }

    public function update(Request $request, string $id): JsonResponse
    {
        return $this->notImplemented('update');
    }

    public function destroy(string $id): JsonResponse
    {
        return $this->notImplemented('destroy');
    }

    public function destroyAllForUser(): JsonResponse
    {
        return $this->notImplemented('destroyAllForUser');
    }
}
