<?php

namespace MbeGroup\Notification\Factories;

use Illuminate\Contracts\Container\Container;
use MbeGroup\Notification\Contracts\NotificationProviderInterface;
use MbeGroup\Notification\Exceptions\UnsupportedNotificationTypeException;

final class NotificationProviderFactory
{
    public function __construct(private Container $container) {}

    public function make(string $type): NotificationProviderInterface
    {
        $class = config("notification.providers.{$type}");

        if (!$class) {
            throw new UnsupportedNotificationTypeException($type);
        }

        return $this->container->make($class);
    }
}
