<?php

namespace MbeGroup\Notification\Mail;

use App\Models\CandidateProfile;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class CombinedNotificationMailable extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        private CandidateProfile $candidate,
        private Collection $results,
    ) {}

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Twoje powiadomienia o ofertach pracy',
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'notification::emails.combined',
            with: [
                'candidate' => $this->candidate,
                'results'   => $this->results,
            ],
        );
    }
}
