<?php
namespace MbeGroup\Notification\Providers;

use Illuminate\Support\ServiceProvider;
use MbeGroup\Notification\Services;
use MbeGroup\Notification\Contracts;
use MbeGroup\Notification\Command\CheckNotificationsCommand;

final class NotificationServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__ . '/../../config/notification.php', 'notification');

        $this->app->bind(
            Contracts\NotificationServiceInterface::class,
            Services\NotificationService::class
        );
    }

    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__ . '/../../routes/api.php');
        $this->loadRoutesFrom(__DIR__ . '/../../routes/console.php');
        $this->loadTranslationsFrom(__DIR__ . '/../../lang', 'notification');
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'notification');
        if ($this->app->runningInConsole()) {
            $this->commands([
                CheckNotificationsCommand::class,
            ]);
        }
        $this->publishes([
            __DIR__ . '/../../config/notification.php' => config_path('notification.php'),
        ], 'notification-config');
    }
}
