<?php

namespace MbeGroup\Notification\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'           => $this->id,
            'name'         => $this->name,
            'type'         => $this->type,
            'frequency'    => $this->frequency,
            'query'        => $this->query,
            'status'       => $this->status,
            'last_sent_at' => $this->last_sent_at?->toIso8601String(),
            'created_at'   => $this->created_at->toIso8601String(),
        ];
    }
}
