<?php

namespace MbeGroup\Notification\Services;

use MbeGroup\Notification\Models\Notification;
use MbeGroup\Notification\Factories\NotificationProviderFactory;
use MbeGroup\Notification\Contracts\NotificationServiceInterface;
use App\ValueObject\Status;

class NotificationService implements NotificationServiceInterface
{
    public function __construct(
        private NotificationProviderFactory $factory
    ) {}

    public function store(array $data, string $type, int $userId): Notification
    {
        $this->factory->make($type);

        return Notification::create([
            'name'            => $data['name'],
            'type'            => $type,
            'frequency'       => $data['frequency'],
            'query'           => $data['query'],
            'user_id'         => $userId,
            'last_queried_at' => null,
            'status'          => Status::ACTIVE
        ]);
    }
}
