<?php

namespace YourOrg\Product\Filament\Resources;

use Modules\Product\Models\Product;

use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use YourOrg\Product\Filament\Resources\ProductResource\Pages\ListProducts;
use YourOrg\Product\Filament\Resources\ProductResource\Pages\CreateProduct;
use YourOrg\Product\Filament\Resources\ProductResource\Pages\EditProduct;

class ProductResource extends Resource
{
    protected static ?string $model = Product::class;

    protected static ?string $navigationIcon = null;

    public static function getNavigationLabel(): string
    {
        return __('homepage::filament.resources.homepage.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('homepage::filament.resources.homepage.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('homepage::filament.resources.homepage.plural_model_label');
    }

    public static function form(Form $form): Form
    {
        return $form->schema([]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label(__('homepage::filament.resources.homepage.table.columns.name'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('slug')
                    ->label(__('homepage::filament.resources.homepage.table.columns.slug'))
                    ->searchable(),
                Tables\Columns\IconColumn::make('enabled')
                    ->label(__('homepage::filament.resources.homepage.table.columns.enabled'))
                    ->boolean(),
                Tables\Columns\TextColumn::make('created_at')
                ->label(__('homepage::filament.resources.homepage.table.columns.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                ->label(__('homepage::filament.resources.homepage.table.columns.updated_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\TernaryFilter::make('enabled'),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->description('Version: ' . \Composer\InstalledVersions::getVersion('mbegroup/homepage'));
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListProducts::route('/'),
            'create' => CreateProduct::route('/create'),
            'edit' => EditProduct::route('/{record}/edit'),
        ];
    }
}
