<?php

namespace YourOrg\Product\Filament\Resources\ProductResource\Pages;

use YourOrg\Product\Filament\Resources\ProductResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Forms\Form;
use Filament\Forms;

class CreateProduct extends CreateRecord
{
    protected static string $resource = ProductResource::class;

    public function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\TextInput::make('name')->label(__('homepage::filament.resources.homepage.form.fields.name'))->required(),
            Forms\Components\TextInput::make('slug')->label(__('homepage::filament.resources.homepage.form.fields.slug'))->required()->unique(ProductResource::getModel(), 'slug', ignoreRecord: true),
        ]);
    }
}
