<?php

namespace YourOrg\Product\Filament\Resources\ProductResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Forms\Form;
use YourOrg\Product\Filament\Resources\ProductResource;
use YourOrg\Product\Filament\Resources\ProductResource\Forms\FormsInterface;

class EditProduct extends EditRecord
{
    protected static string $resource = ProductResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    public function form(Form $form): Form
    {
        $class = 'YourOrg\\Product\\Filament\\Resources\\ProductResource\\Forms\\' . str_replace(' ', '', ucwords(str_replace(['-', '_'], ' ', $this->record->slug)));

        if (!class_exists($class) || !in_array(FormsInterface::class, class_implements($class))) {
            throw new \Exception("Class $class does not exist or does not implement FormsInterface");
        }

        $schema = $class::formSchema($form);

        return $schema;
    }
}
