<?php
namespace Modules\Product\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Product extends Model
{
    use HasFactory;

    protected $table = 'products';
    
    protected $fillable = [
        'name',
        'price_net',
        'category',
        'unit',
        'quantity',
        'enabled',
    ];

    protected $casts = [
        'price_net' => 'decimal:2',
        'quantity'  => 'integer',
        'enabled'   => 'boolean',
    ];

    public const CATEGORIES = [
        'oferty_pracy' => 'Oferty pracy',
        'wizerunek'    => 'Wizerunek',
    ];

    public const UNITS = [
        'sztuka'  => 'Sztuka',
        'miesiac' => 'Miesiąc',
    ];

    public function getCategoryNameAttribute(): string
    {
        return self::CATEGORIES[$this->category] ?? $this->category;
    }

    public function getUnitNameAttribute(): string
    {
        return self::UNITS[$this->unit] ?? $this->unit;
    }
}
