<?php

namespace MbeGroup\Product\Filament\Resources;

use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use MbeGroup\Product\Filament\Resources\ProductStatisticsResource\Pages\ListProductStatistics;


class ProductStatisticsResource extends Resource
{
    public static function getNavigationGroup(): string
    {
        return __('product::filament.navigation.group.label');
    }

    public static function getNavigationLabel(): string
    {
        return __('product::filament.resources.product_statistics.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('product::filament.resources.product_statistics.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('product::filament.resources.product_statistics.plural_model_label');
    }

    public static function form(Schema $schema): Schema
    {
        return $schema->schema([]);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListProductStatistics::route('/'),
        ];
    }
}
