<?php
namespace MbeGroup\Product\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\ValueObject\Status;

class Product extends Model
{
    use HasFactory;

    protected $table = 'products';

    protected $fillable = [
        'name',
        'price_net',
        'category',
        'unit',
        'quantity',
        'status',
    ];

    protected function casts(): array
    {
        return [
            'price_net' => 'decimal:2',
            'quantity'  => 'integer',
            'status'    => Status::class,
        ];
    }

    public const CATEGORIES = [
        'oferty_pracy' => 'Oferty pracy',
        'wizerunek'    => 'Wizerunek',
    ];

    public const UNITS = [
        'sztuka'  => 'Sztuka',
        'miesiac' => 'Miesiąc',
    ];

    public function getCategoryNameAttribute(): string
    {
        return self::CATEGORIES[$this->category] ?? $this->category;
    }

    public function getUnitNameAttribute(): string
    {
        return self::UNITS[$this->unit] ?? $this->unit;
    }

    /**
     * Relacja z zamówieniami produktu (tabela łącząca)
     */
    public function productOrders()
    {
        return $this->hasMany(ProductStatistics::class);
    }

    /**
     * Relacja many-to-many z pracodawcami przez tabelę łączącą
     */
    public function employers()
    {
        return $this->hasManyThrough(
            \MbeGroup\Employer\Models\Employer::class,
            ProductStatistics::class,
            'product_id',  // klucz obcy w tabeli product_statistics
            'id',          // klucz lokalny w tabeli employers
            'id',          // klucz lokalny w tabeli products
            'employer_id'  // klucz obcy w tabeli product_statistics
        );
    }
}
