<?php
namespace MbeGroup\Product\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\ValueObject\Status;

class Product extends Model
{
    use HasFactory;

    protected $table = 'products';

    protected $fillable = [
        'name',
        'price_net',
        'category',
        'quantity',
        'status',
        'validity_period_start',
        'validity_period_end',
        'product_life_start',
        'product_life_end',
    ];

    protected function casts(): array
    {
        return [
            'price_net'             => 'decimal:2',
            'quantity'              => 'integer',
            'status'                => Status::class,
            'validity_period_start' => 'date',
            'validity_period_end'   => 'date',
            'product_life_start'    => 'date',
            'product_life_end'      => 'date',
        ];
    }

    public const CATEGORIES = [
        'oferty_pracy' => 'Oferty pracy',
        'wizerunek'    => 'Wizerunek',
    ];


    public function getCategoryNameAttribute(): string
    {
        return self::CATEGORIES[$this->category] ?? $this->category;
    }

          /**
     * Relacja z zamówieniami produktu (tabela łącząca)
     */
    public function productOrders()
    {
        return $this->hasMany(ProductStatistics::class);
    }

          /**
     * Relacja many-to-many z pracodawcami przez tabelę łączącą
     */
    public function employers()
    {
        return $this->hasManyThrough(
            \MbeGroup\Employer\Models\Employer::class,
            ProductStatistics::class,
            'product_id',
            'id'        ,
            'id'        ,
            'employer_id'
        );
    }
}
