<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_statistics', function (Blueprint $table) {
            $table->id();
            $table->string('employer_id'); // MongoDB ObjectId jako string
            $table->unsignedBigInteger('product_id');
            $table->integer('quantity')->default(1);
            $table->decimal('price', 10, 2)->nullable();
            $table->date('valid_from')->nullable();
            $table->date('valid_to')->nullable();
            $table->tinyInteger('status')->default(1); // 0=nieaktywny, 1=aktywny, 2=w trakcie
            $table->timestamps();

            // Indeksy
            $table->index('employer_id');
            $table->index('product_id');
            $table->index('status');
            $table->index(['employer_id', 'product_id']);

            // Klucz obcy do tabeli products
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_statistics');
    }
};
