<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'validity_period_start',
                'validity_period_end',
                'product_life_start',
                'product_life_end',
            ]);
            $table->integer('validity_period_months')->nullable()->after('status');
            $table->integer('product_life_months')->nullable()->after('validity_period_months');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'validity_period_months',
                'product_life_months',
            ]);
            $table->date('validity_period_start')->nullable()->after('status');
            $table->date('validity_period_end')->nullable()->after('validity_period_start');
            $table->date('product_life_start')->nullable()->after('validity_period_end');
            $table->date('product_life_end')->nullable()->after('product_life_start');
        });
    }
};
