<?php

namespace MbeGroup\Product\Filament\Exports;

use MbeGroup\Product\Models\ProductStatistics;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;
use Illuminate\Support\Number;
use App\ValueObject\Status;

class ProductStatisticsExporter extends Exporter
{
    protected static ?string $model = ProductStatistics::class;

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('employer_name')
                ->label(__('product::filament.resources.product_statistics.table.columns.employer_name'))
                ->getStateUsing(function ($record) {
                    $employer = \MbeGroup\Employer\Models\Employer::find($record->employer_id);
                    return $employer ? $employer->name : 'Brak danych';
                }),
            ExportColumn::make('product.name')
                ->label(__('product::filament.resources.product_statistics.table.columns.product_name')),
            ExportColumn::make('quantity')
                ->label(__('product::filament.resources.product_statistics.table.columns.quantity')),
            ExportColumn::make('price')
                ->label(__('product::filament.resources.product_statistics.table.columns.price')),
            ExportColumn::make('created_at')
                ->label(__('product::filament.resources.product_statistics.table.columns.created_at')),
            ExportColumn::make('valid_from')
                ->label(__('product::filament.resources.product_statistics.table.columns.valid_from')),
            ExportColumn::make('valid_to')
                ->label(__('product::filament.resources.product_statistics.table.columns.valid_to')),
            ExportColumn::make('status')
                ->label(__('product::filament.resources.product_statistics.table.columns.status'))
                ->getStateUsing(fn ($record) => Status::label($record->status)),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $body = 'Your product statistics export has completed and ' . Number::format($export->successful_rows) . ' ' . str('row')->plural($export->successful_rows) . ' exported.';

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $body .= ' ' . Number::format($failedRowsCount) . ' ' . str('row')->plural($failedRowsCount) . ' failed to export.';
        }

        return $body;
    }
}
