<?php

namespace MbeGroup\Product\Console\Commands;

use Illuminate\Console\Command;
use MbeGroup\Product\Contracts\ProductServiceInterface;
use Illuminate\Support\Facades\Log;

class DisableProducts extends Command
{
    public function __construct(
        private ProductServiceInterface $productService
    ) {
        parent::__construct();
    }

      /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'products:disable-products';

      /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

      /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Starting product disabling...');

        try {
            $count = $this->productService->disableExpiredProducts();

            $this->info("Successfully disabled {$count} products.");
            Log::info("Disabled {$count} products via cron");

            return Command::SUCCESS;
        } catch (\Exception $e) {
            $this->error('Failed to disable products: ' . $e->getMessage());
            Log::error('Product disabling failed', ['error' => $e->getMessage()]);

            return Command::FAILURE;
        }
    }
}
