<?php
namespace MbeGroup\Product\Providers;

use Illuminate\Support\ServiceProvider;
use MbeGroup\Product\Services\ProductService;
use MbeGroup\Product\Contracts\ProductServiceInterface;
use MbeGroup\Product\Console\Commands\DisableProducts;

final class ProductServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->bind(ProductServiceInterface::class, ProductService::class);
    }

    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__ . '/../../routes/api.php');
        $this->loadTranslationsFrom(__DIR__ . '/../../lang', 'product');
        if ($this->app->runningInConsole()) {
            $this->commands([
                DisableProducts::class,
            ]);
        }
    }
}
