<?php

namespace MbeGroup\Product\Services;

use MbeGroup\Product\Contracts\ProductServiceInterface;
use MbeGroup\Product\Models\ProductStatistics;
use App\ValueObject\Status;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ProductService implements ProductServiceInterface
{
    public function disableExpiredProducts(): void
    {
        $expiredProducts = ProductStatistics::with('employer')
            ->whereNotNull('valid_to')
            ->where('valid_to', '<', now())
            ->where('status', '!=', Status::INACTIVE)
            ->get();

        foreach ($expiredProducts as $product) {
            DB::beginTransaction();

            try {
                $product->status = Status::INACTIVE;
                $product->save();

                if ($product->employer && $product->employer_item_id) {
                    $product->employer->pull('products', [
                        'item_id' => $product->employer_item_id
                    ]);
                }

                DB::commit();

                Log::info("Product disabled and removed from employer", [
                    'product_id'  => $product->id,
                    'employer_id' => $product->employer_id,
                    'item_id'     => $product->employer_item_id
                ]);

            } catch (\Exception $e) {
                DB::rollBack();

                Log::error("Failed to disable product", [
                    'product_id' => $product->id,
                    'error'      => $e->getMessage()
                ]);
            }
        }
    }
}
