<?php
namespace MbeGroup\Product\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\ValueObject\Status;
use MbeGroup\Employer\Models\Employer;

class ProductStatistics extends Model
{
    use HasFactory;

    protected $table = 'product_statistics';

    protected $fillable = [
        'employer_id',
        'employer_item_id',
        'product_id',
        'quantity',
        'price',
        'valid_from',
        'valid_to',
        'status',
    ];

    protected function casts(): array
    {
        return [
            'quantity'         => 'integer',
            'price'            => 'decimal:2',
            'valid_from'       => 'date',
            'valid_to'         => 'date',
            'status'           => Status::class,
            'employer_item_id' => 'string',
            'employer_id'      => 'string',
        ];
    }

      /**
     * Relacja z pracodawcą
     */
    public function employer(): BelongsTo
    {
        return $this->belongsTo(Employer::class);
    }

      /**
     * Relacja z produktem
     */
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

      /**
     * Scope dla aktywnych zamówień
     */
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

      /**
     * Scope dla zamówień według pracodawcy
     */
    public function scopeByEmployer($query, $employerId)
    {
        return $query->where('employer_id', $employerId);
    }

      /**
     * Scope dla zamówień według produktu
     */
    public function scopeByProduct($query, $productId)
    {
        return $query->where('product_id', $productId);
    }
}
