<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->integer('product_life_days')->nullable()->after('validity_period_months');
        });
        DB::table('products')
            ->whereNotNull('product_life_months')
            ->update([
                'product_life_days' => DB::raw('product_life_months * 30')
            ]);

        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn('product_life_months');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->integer('product_life_months')->nullable()->after('validity_period_months');
        });

        DB::table('products')
            ->whereNotNull('product_life_days')
            ->update([
                'product_life_months' => DB::raw('ROUND(product_life_days / 30)')
            ]);

        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn('product_life_days');
        });
    }
};
