<?php

namespace MbeGroup\Product\Filament;

use Filament\Contracts\Plugin;
use Filament\Panel;
use MbeGroup\Product\Filament\Resources\ProductResource;
use MbeGroup\Product\Filament\Resources\ProductStatisticsResource;
use Filament\Facades\Filament;
use Filament\Navigation\NavigationGroup;

class ProductPlugin implements Plugin
{
    public function getId(): string { return 'product'; }

    public function register(Panel $panel): void
    {
        $panel->resources([
            ProductResource::class,
            ProductStatisticsResource::class,
        ]);
        // $panel->pages([...]); $panel->widgets([...]);
    }

    public function boot(Panel $panel): void
    {
        Filament::serving(function () {
            Filament::registerNavigationGroups([
                NavigationGroup::make()
                     ->label(__('product::filament.navigation.group.label'))
                     ->icon('heroicon-s-shopping-cart'),
            ]);
        });
    }
}
